export enum ModuleType {
  Simulation = 'simulation',
  Sensor = 'sensor',
  FloorZone = 'floorzone',
  Upload = 'upload',
}

export interface ModuleConfig {
  [key: string]: any;
}

export interface GridPosition {
  row: number;
  col: number;
}

export interface Module {
  id: string;
  type: ModuleType;
  config: ModuleConfig;
  position: GridPosition;
  floorId: string;
  collapsed?: boolean;
}

export interface Floor {
  id: string;
  name: string;
  modules: (Module | null)[][]; // 4x4 grid, null for empty cells
}

export interface BuildingConfig {
  floors: Floor[];
}

export interface SensorType {
  id: string;
  name: string;
  icon: string;
  enabled: boolean;
  priority: number;
}

export interface Zone {
  id: string;
  name: string;
  floorId: string;
}

export interface SimulationConfig extends ModuleConfig {
  description: string;
  sampleOutput?: string;
}

export interface SensorConfig extends ModuleConfig {
  selectedSensors: SensorType[];
}

export interface FloorZoneConfig extends ModuleConfig {
  selectedFloor: string;
  zones: Zone[];
}

export interface UploadConfig extends ModuleConfig {
  files: File[];
  uploadStatus: 'idle' | 'uploading' | 'success' | 'error';
}

export interface ComponentLibraryItem {
  id: string;
  type: ModuleType;
  title: string;
  icon: string;
  description: string;
}

