import { Helmet } from 'react-helmet-async';
import Navbar from './Navbar';
import Hero from './Hero';
import KeyFeatures from './KeyFeatures';
import ValueDelivered from './ValueDelivered';
import AIDigitalTwin from './AIDigitalTwin';

import CTABanner from './CTABanner';
import Footer from './Footer';

export default function HomePage() {
    return (
        <main className="bg-dark min-h-screen text-white overflow-x-hidden">
            <Helmet>
                <title>Mutqin Pro - Unified Compliance & Sustainability Platform</title>
                <meta name="description" content="Mutqin Pro is the leading AI-powered platform for compliance, sustainability, and quality management in Saudi Arabia. Automate your ISO, ESG, and carbon reporting." />
            </Helmet>
            <Navbar />
            <Hero />

            <KeyFeatures />
            
            <section className="py-12">
                <div className="container mx-auto px-6">
                    <h2 className="text-4xl font-bold mb-4 text-center">Key <span className="text-gradient">Features</span></h2>
                </div>
            </section>
            
            <ValueDelivered />
            <AIDigitalTwin />
            <CTABanner />
            <Footer />
        </main>
    );
}
