import { Twitter, Linkedin, Mail, MapPin, Phone } from 'lucide-react';

export default function Footer() {
    return (
        <footer className="bg-dark border-t border-white/10 pt-20 pb-10">
            <div className="container mx-auto px-6">
                <div className="grid md:grid-cols-4 gap-12 mb-16">
                    {/* Brand */}
                    <div className="col-span-1 md:col-span-2">
                    <div className="flex items-center gap-0 mb-6">
    <img
        src="/logo-icon.png"
        alt="Mutqin Pro Logo"
        className="w-14 h-14 object-contain"
    />

    <div className="flex flex-col leading-tight">
        <span className="text-xl font-bold text-white tracking-tight">
            MUTQIN <span className="text-primary">Pro</span>
        </span>

        <span className="text-[10px] text-gray-400 tracking-widest flex gap-1">
            <span>QUALITY</span>
            <span>•</span>
            <span>INNOVATION</span>
            <span>•</span>
            <span>INTEGRITY</span>
        </span>
    </div>
</div>
                        <p className="text-gray-400 max-w-sm leading-relaxed mb-8">
                            The unified Saudi platform for compliance, sustainability, and operational excellence. Powered by AI and Digital Twin technology.
                        </p>
                        <div className="flex gap-4">
                            {[Twitter, Linkedin, Mail].map((Icon, i) => (
                                <a key={i} href="#" className="w-10 h-10 rounded-full bg-white/5 flex items-center justify-center text-gray-400 hover:bg-primary hover:text-white transition-all duration-300">
                                    <Icon className="w-5 h-5" />
                                </a>
                            ))}
                        </div>
                    </div>

                    {/* Links */}
                    <div>
                        <h4 className="text-white font-bold mb-6">Platform</h4>
                        <ul className="space-y-4">
                            {['Solutions', 'Features', 'Pricing', 'Case Studies', 'API'].map((item) => (
                                <li key={item}>
                                    <a href="#" className="text-gray-400 hover:text-primary transition-colors">{item}</a>
                                </li>
                            ))}
                        </ul>
                    </div>

                    {/* Contact */}
                    <div>
                        <h4 className="text-white font-bold mb-6">Contact</h4>
                        <ul className="space-y-4">
                            <li className="flex items-start gap-3 text-gray-400">
                                <MapPin className="w-5 h-5 text-primary flex-shrink-0 mt-1" />
                                <span>Riyadh, Saudi Arabia<br />King Fahd Road</span>
                            </li>
                            <li className="flex items-center gap-3 text-gray-400">
                                <Phone className="w-5 h-5 text-primary flex-shrink-0" />
                                <span>+966 50 378 8015</span>
                            </li>
                            <li className="flex items-center gap-3 text-gray-400">
                                <Mail className="w-5 h-5 text-primary flex-shrink-0" />
                                <span>info@mutqinpro.com</span>
                            </li>
                        </ul>
                    </div>
                </div>

                <div className="border-t border-white/10 pt-8 flex flex-col md:flex-row justify-between items-center gap-4">
                    <p className="text-gray-500 text-sm">
                        © 2024 Mutqin Pro. All rights reserved.
                    </p>
                    <div className="flex gap-8 text-sm text-gray-500">
                        <a href="#" className="hover:text-white transition-colors">Privacy Policy</a>
                        <a href="#" className="hover:text-white transition-colors">Terms of Service</a>
                    </div>
                </div>
            </div>
        </footer>
    );
}
