import { useEffect } from 'react';
import { useAuth } from '../contexts/AuthContext';

export default function DashboardPage() {
  const { isAuthenticated } = useAuth();

  useEffect(() => {
    // Redirect to dashboard.html if authenticated
    if (isAuthenticated) {
      window.location.href = '/dashboard.html';
    }
  }, [isAuthenticated]);

  // Show loading state while redirecting
  return (
    <div className="min-h-screen bg-dark flex items-center justify-center">
      <div className="w-8 h-8 border-2 border-primary/30 border-t-primary rounded-full animate-spin" />
    </div>
  );
}

