import { motion } from 'framer-motion';
import { ArrowRight } from 'lucide-react';

export default function CTABanner() {
    return (
        <section className="py-24 relative overflow-hidden">
            <div className="absolute inset-0 bg-gradient-to-r from-primary/20 to-secondary/20 backdrop-blur-3xl" />

            <div className="container mx-auto px-6 relative z-10 text-center">
                <motion.div
                    initial={{ opacity: 0, y: 20 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    viewport={{ once: true }}
                    className="max-w-4xl mx-auto"
                >
                    <h2 className="text-4xl md:text-6xl font-bold mb-8 leading-tight">
                        Experience automated <span className="text-gradient">sustainability</span> & compliance management.
                    </h2>

                    <motion.button
                        whileHover={{ scale: 1.05 }}
                        whileTap={{ scale: 0.95 }}
                        className="bg-primary hover:bg-primary/90 text-white px-10 py-5 rounded-2xl font-bold text-xl transition-all shadow-lg shadow-primary/30 flex items-center gap-3 mx-auto"
                    >
                        Request a Free Demo
                        <ArrowRight className="w-6 h-6" />
                    </motion.button>
                </motion.div>
            </div>
        </section>
    );
}
